
from flask import Flask, render_template, request, redirect, session, url_for
import sqlite3, os

app = Flask(__name__)
app.secret_key = 'secret_key'

DB_PATH = 'bluecc.db'

def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute('''CREATE TABLE IF NOT EXISTS users (
                        id INTEGER PRIMARY KEY,
                        username TEXT UNIQUE,
                        password TEXT)''')
        c.execute('''CREATE TABLE IF NOT EXISTS projects (
                        id INTEGER PRIMARY KEY,
                        user_id INTEGER,
                        name TEXT,
                        location TEXT,
                        ecosystem TEXT,
                        description TEXT)''')
init_db()

@app.route('/')
def index():
    return render_template('index.html')

@app.route('/register', methods=['GET', 'POST'])
def register():
    if request.method == 'POST':
        with sqlite3.connect(DB_PATH) as conn:
            c = conn.cursor()
            try:
                c.execute("INSERT INTO users (username, password) VALUES (?, ?)",
                          (request.form['username'], request.form['password']))
                conn.commit()
                return redirect('/login')
            except:
                return "Erro: utilizador já existe."
    return render_template('register.html')

@app.route('/login', methods=['GET', 'POST'])
def login():
    if request.method == 'POST':
        with sqlite3.connect(DB_PATH) as conn:
            c = conn.cursor()
            c.execute("SELECT * FROM users WHERE username=? AND password=?",
                      (request.form['username'], request.form['password']))
            user = c.fetchone()
            if user:
                session['user_id'] = user[0]
                return redirect('/submit')
            else:
                return "Login inválido."
    return render_template('login.html')

@app.route('/submit', methods=['GET', 'POST'])
def submit():
    if 'user_id' not in session:
        return redirect('/login')
    if request.method == 'POST':
        with sqlite3.connect(DB_PATH) as conn:
            c = conn.cursor()
            c.execute("INSERT INTO projects (user_id, name, location, ecosystem, description) VALUES (?, ?, ?, ?, ?)",
                      (session['user_id'], request.form['name'], request.form['location'],
                       request.form['ecosystem'], request.form['description']))
            conn.commit()
            return redirect('/projects')
    return render_template('submit_project.html')

@app.route('/projects')
def projects():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("SELECT name, location, ecosystem, description FROM projects")
        rows = c.fetchall()
    return render_template('public_projects.html', projects=rows)

if __name__ == '__main__':
    app.run()

@app.route('/my-projects')
def my_projects():
    if 'user_id' not in session:
        return redirect('/login')
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("SELECT * FROM projects WHERE user_id=?", (session['user_id'],))
        rows = c.fetchall()
    return render_template('my_projects.html', projects=rows)

@app.route('/edit-project/<int:project_id>', methods=['GET', 'POST'])
def edit_project(project_id):
    if 'user_id' not in session:
        return redirect('/login')
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        if request.method == 'POST':
            c.execute("UPDATE projects SET name=?, location=?, ecosystem=?, description=? WHERE id=? AND user_id=?",
                      (request.form['name'], request.form['location'], request.form['ecosystem'],
                       request.form['description'], project_id, session['user_id']))
            conn.commit()
            return redirect('/my-projects')
        c.execute("SELECT * FROM projects WHERE id=? AND user_id=?", (project_id, session['user_id']))
        project = c.fetchone()
    return render_template('edit_project.html', project=project)

@app.route('/delete-project/<int:project_id>')
def delete_project(project_id):
    if 'user_id' not in session:
        return redirect('/login')
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("DELETE FROM projects WHERE id=? AND user_id=?", (project_id, session['user_id']))
        conn.commit()
    return redirect('/my-projects')
